/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.apache.commons.dbutils.AbstractQueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncQueryRunner
extends AbstractQueryRunner {
    private final ExecutorService executorService;

    public AsyncQueryRunner(ExecutorService executorService) {
        this(null, false, executorService);
    }

    public AsyncQueryRunner(boolean pmdKnownBroken, ExecutorService executorService) {
        this(null, pmdKnownBroken, executorService);
    }

    public AsyncQueryRunner(DataSource ds, ExecutorService executorService) {
        this(ds, false, executorService);
    }

    public AsyncQueryRunner(DataSource ds, boolean pmdKnownBroken, ExecutorService executorService) {
        super(ds, pmdKnownBroken);
        this.executorService = executorService;
    }

    public Future<int[]> batch(Connection conn, String sql, Object[][] params) throws SQLException {
        return this.executorService.submit(this.batch(conn, false, sql, params));
    }

    public Future<int[]> batch(String sql, Object[][] params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.executorService.submit(this.batch(conn, true, sql, params));
    }

    private Callable<int[]> batch(Connection conn, boolean closeConn, String sql, Object[][] params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null SQL statement");
        }
        if (params == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null parameters. If parameters aren't need, pass an empty array.");
        }
        PreparedStatement stmt = null;
        BatchCallableStatement ret = null;
        try {
            stmt = this.prepareStatement(conn, sql);
            for (int i = 0; i < params.length; ++i) {
                this.fillStatement(stmt, params[i]);
                stmt.addBatch();
            }
            ret = new BatchCallableStatement(sql, params, conn, closeConn, stmt);
        }
        catch (SQLException e) {
            this.close(stmt);
            this.close(conn);
            this.rethrow(e, sql, (Object[])params);
        }
        return ret;
    }

    private <T> Callable<T> query(Connection conn, boolean closeConn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        PreparedStatement stmt = null;
        QueryCallableStatement<T> ret = null;
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null SQL statement");
        }
        if (rsh == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null ResultSetHandler");
        }
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            ret = new QueryCallableStatement<T>(conn, closeConn, stmt, rsh, sql, params);
        }
        catch (SQLException e) {
            this.close(stmt);
            if (closeConn) {
                this.close(conn);
            }
            this.rethrow(e, sql, params);
        }
        return ret;
    }

    public <T> Future<T> query(Connection conn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        return this.executorService.submit(this.query(conn, false, sql, rsh, params));
    }

    public <T> Future<T> query(Connection conn, String sql, ResultSetHandler<T> rsh) throws SQLException {
        return this.executorService.submit(this.query(conn, false, sql, rsh, (Object[])null));
    }

    public <T> Future<T> query(String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.executorService.submit(this.query(conn, true, sql, rsh, params));
    }

    public <T> Future<T> query(String sql, ResultSetHandler<T> rsh) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.executorService.submit(this.query(conn, true, sql, rsh, (Object[])null));
    }

    private Callable<Integer> update(Connection conn, boolean closeConn, String sql, Object ... params) throws SQLException {
        PreparedStatement stmt = null;
        UpdateCallableStatement ret = null;
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null SQL statement");
        }
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            ret = new UpdateCallableStatement(conn, closeConn, stmt, sql, params);
        }
        catch (SQLException e) {
            this.close(stmt);
            if (closeConn) {
                this.close(conn);
            }
            this.rethrow(e, sql, params);
        }
        return ret;
    }

    public Future<Integer> update(Connection conn, String sql) throws SQLException {
        return this.executorService.submit(this.update(conn, false, sql, (Object[])null));
    }

    public Future<Integer> update(Connection conn, String sql, Object param) throws SQLException {
        return this.executorService.submit(this.update(conn, false, sql, param));
    }

    public Future<Integer> update(Connection conn, String sql, Object ... params) throws SQLException {
        return this.executorService.submit(this.update(conn, false, sql, params));
    }

    public Future<Integer> update(String sql) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.executorService.submit(this.update(conn, true, sql, (Object[])null));
    }

    public Future<Integer> update(String sql, Object param) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.executorService.submit(this.update(conn, true, sql, param));
    }

    public Future<Integer> update(String sql, Object ... params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.executorService.submit(this.update(conn, true, sql, params));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UpdateCallableStatement
    implements Callable<Integer> {
        private String sql;
        private Object[] params;
        private Connection conn;
        private boolean closeConn;
        private PreparedStatement ps;

        public UpdateCallableStatement(Connection conn, boolean closeConn, PreparedStatement ps, String sql, Object ... params) {
            this.sql = sql;
            this.params = params;
            this.conn = conn;
            this.closeConn = closeConn;
            this.ps = ps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer call() throws SQLException {
            int rows = 0;
            try {
                rows = this.ps.executeUpdate();
            }
            catch (SQLException e) {
                AsyncQueryRunner.this.rethrow(e, this.sql, this.params);
            }
            finally {
                AsyncQueryRunner.this.close(this.ps);
                if (this.closeConn) {
                    AsyncQueryRunner.this.close(this.conn);
                }
            }
            return rows;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class QueryCallableStatement<T>
    implements Callable<T> {
        private String sql;
        private Object[] params;
        private Connection conn;
        private boolean closeConn;
        private PreparedStatement ps;
        private ResultSetHandler<T> rsh;

        public QueryCallableStatement(Connection conn, boolean closeConn, PreparedStatement ps, ResultSetHandler<T> rsh, String sql, Object ... params) {
            this.sql = sql;
            this.params = params;
            this.conn = conn;
            this.closeConn = closeConn;
            this.ps = ps;
            this.rsh = rsh;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws SQLException {
            ResultSet rs = null;
            T ret = null;
            try {
                rs = AsyncQueryRunner.this.wrap(this.ps.executeQuery());
                ret = this.rsh.handle(rs);
            }
            catch (SQLException e) {
                AsyncQueryRunner.this.rethrow(e, this.sql, this.params);
            }
            finally {
                try {
                    AsyncQueryRunner.this.close(rs);
                }
                finally {
                    AsyncQueryRunner.this.close(this.ps);
                    if (this.closeConn) {
                        AsyncQueryRunner.this.close(this.conn);
                    }
                }
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BatchCallableStatement
    implements Callable<int[]> {
        private String sql;
        private Object[][] params;
        private Connection conn;
        private boolean closeConn;
        private PreparedStatement ps;

        public BatchCallableStatement(String sql, Object[][] params, Connection conn, boolean closeConn, PreparedStatement ps) {
            this.sql = sql;
            this.params = params;
            this.conn = conn;
            this.closeConn = closeConn;
            this.ps = ps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int[] call() throws SQLException {
            int[] ret = null;
            try {
                ret = this.ps.executeBatch();
            }
            catch (SQLException e) {
                AsyncQueryRunner.this.rethrow(e, this.sql, (Object[])this.params);
            }
            finally {
                AsyncQueryRunner.this.close(this.ps);
                if (this.closeConn) {
                    AsyncQueryRunner.this.close(this.conn);
                }
            }
            return ret;
        }
    }
}

