/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis.v07.handlers.sax;

import com.alibaba.excel.analysis.v07.handlers.CellFormulaTagHandler;
import com.alibaba.excel.analysis.v07.handlers.CellInlineStringValueTagHandler;
import com.alibaba.excel.analysis.v07.handlers.CellTagHandler;
import com.alibaba.excel.analysis.v07.handlers.CellValueTagHandler;
import com.alibaba.excel.analysis.v07.handlers.CountTagHandler;
import com.alibaba.excel.analysis.v07.handlers.HyperlinkTagHandler;
import com.alibaba.excel.analysis.v07.handlers.MergeCellTagHandler;
import com.alibaba.excel.analysis.v07.handlers.RowTagHandler;
import com.alibaba.excel.analysis.v07.handlers.XlsxTagHandler;
import com.alibaba.excel.context.xlsx.XlsxReadContext;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XlsxRowHandler
extends DefaultHandler {
    private XlsxReadContext xlsxReadContext;
    private static final Map<String, XlsxTagHandler> XLSX_CELL_HANDLER_MAP = new HashMap<String, XlsxTagHandler>(32);

    public XlsxRowHandler(XlsxReadContext xlsxReadContext) {
        this.xlsxReadContext = xlsxReadContext;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        XlsxTagHandler handler = XLSX_CELL_HANDLER_MAP.get(name);
        if (handler == null || !handler.support(this.xlsxReadContext)) {
            return;
        }
        this.xlsxReadContext.xlsxReadSheetHolder().getTagDeque().push(name);
        handler.startElement(this.xlsxReadContext, name, attributes);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String currentTag = this.xlsxReadContext.xlsxReadSheetHolder().getTagDeque().peek();
        if (currentTag == null) {
            return;
        }
        XlsxTagHandler handler = XLSX_CELL_HANDLER_MAP.get(currentTag);
        if (handler == null || !handler.support(this.xlsxReadContext)) {
            return;
        }
        handler.characters(this.xlsxReadContext, ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        XlsxTagHandler handler = XLSX_CELL_HANDLER_MAP.get(name);
        if (handler == null || !handler.support(this.xlsxReadContext)) {
            return;
        }
        handler.endElement(this.xlsxReadContext, name);
        this.xlsxReadContext.xlsxReadSheetHolder().getTagDeque().pop();
    }

    static {
        CellFormulaTagHandler cellFormulaTagHandler = new CellFormulaTagHandler();
        XLSX_CELL_HANDLER_MAP.put("f", cellFormulaTagHandler);
        XLSX_CELL_HANDLER_MAP.put("x:f", cellFormulaTagHandler);
        CellInlineStringValueTagHandler cellInlineStringValueTagHandler = new CellInlineStringValueTagHandler();
        XLSX_CELL_HANDLER_MAP.put("t", cellInlineStringValueTagHandler);
        XLSX_CELL_HANDLER_MAP.put("x:t", cellInlineStringValueTagHandler);
        CellTagHandler cellTagHandler = new CellTagHandler();
        XLSX_CELL_HANDLER_MAP.put("c", cellTagHandler);
        XLSX_CELL_HANDLER_MAP.put("x:c", cellTagHandler);
        CellValueTagHandler cellValueTagHandler = new CellValueTagHandler();
        XLSX_CELL_HANDLER_MAP.put("v", cellValueTagHandler);
        XLSX_CELL_HANDLER_MAP.put("x:v", cellValueTagHandler);
        CountTagHandler countTagHandler = new CountTagHandler();
        XLSX_CELL_HANDLER_MAP.put("dimension", countTagHandler);
        XLSX_CELL_HANDLER_MAP.put("x:dimension", countTagHandler);
        HyperlinkTagHandler hyperlinkTagHandler = new HyperlinkTagHandler();
        XLSX_CELL_HANDLER_MAP.put("hyperlink", hyperlinkTagHandler);
        XLSX_CELL_HANDLER_MAP.put("x:hyperlink", hyperlinkTagHandler);
        MergeCellTagHandler mergeCellTagHandler = new MergeCellTagHandler();
        XLSX_CELL_HANDLER_MAP.put("mergeCell", mergeCellTagHandler);
        XLSX_CELL_HANDLER_MAP.put("x:mergeCell", mergeCellTagHandler);
        RowTagHandler rowTagHandler = new RowTagHandler();
        XLSX_CELL_HANDLER_MAP.put("row", rowTagHandler);
        XLSX_CELL_HANDLER_MAP.put("x:row", rowTagHandler);
    }
}

