/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2OutputVisitor;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleParameterizedOutputVisitor;
import com.alibaba.druid.sql.dialect.phoenix.visitor.PhoenixOutputVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGOutputVisitor;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerOutputVisitor;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLSelectListCache;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.ParameterizedVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.VisitorFeature;
import com.alibaba.druid.util.FnvHash;
import java.util.List;

public class ParameterizedOutputVisitorUtils {
    private static final SQLParserFeature[] defaultFeatures = new SQLParserFeature[]{SQLParserFeature.EnableSQLBinaryOpExprGroup, SQLParserFeature.UseInsertColumnsCache, SQLParserFeature.OptimizedForParameterized};
    private static final SQLParserFeature[] defaultFeatures2 = new SQLParserFeature[]{SQLParserFeature.EnableSQLBinaryOpExprGroup, SQLParserFeature.UseInsertColumnsCache, SQLParserFeature.OptimizedForParameterized, SQLParserFeature.OptimizedForForParameterizedSkipValue};

    public static String parameterize(String sql, String dbType) {
        return ParameterizedOutputVisitorUtils.parameterize(sql, dbType, null, null);
    }

    public static String parameterize(String sql, String dbType, SQLSelectListCache selectListCache) {
        return ParameterizedOutputVisitorUtils.parameterize(sql, dbType, selectListCache, null, new VisitorFeature[0]);
    }

    public static String parameterize(String sql, String dbType, List<Object> outParameters) {
        return ParameterizedOutputVisitorUtils.parameterize(sql, dbType, null, outParameters, new VisitorFeature[0]);
    }

    private static void configVisitorFeatures(ParameterizedVisitor visitor, VisitorFeature ... features) {
        if (features != null) {
            for (int i = 0; i < features.length; ++i) {
                visitor.config(features[i], true);
            }
        }
    }

    public static String parameterize(String sql, String dbType, List<Object> outParameters, VisitorFeature ... features) {
        return ParameterizedOutputVisitorUtils.parameterize(sql, dbType, null, outParameters, features);
    }

    public static String parameterize(String sql, String dbType, SQLSelectListCache selectListCache, List<Object> outParameters, VisitorFeature ... visitorFeatures) {
        List<SQLStatement> statementList;
        SQLParserFeature[] features = outParameters == null ? defaultFeatures2 : defaultFeatures;
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser(sql, dbType, features);
        if (selectListCache != null) {
            parser.setSelectListCache(selectListCache);
        }
        if ((statementList = parser.parseStatementList()).size() == 0) {
            return sql;
        }
        StringBuilder out = new StringBuilder(sql.length());
        ParameterizedVisitor visitor = ParameterizedOutputVisitorUtils.createParameterizedOutputVisitor(out, dbType);
        if (outParameters != null) {
            visitor.setOutputParameters(outParameters);
        }
        ParameterizedOutputVisitorUtils.configVisitorFeatures(visitor, visitorFeatures);
        for (int i = 0; i < statementList.size(); ++i) {
            Class<?> stmtClass;
            SQLStatement stmt = statementList.get(i);
            if (i > 0) {
                SQLStatement preStmt = statementList.get(i - 1);
                if (preStmt.getClass() == stmt.getClass()) {
                    StringBuilder buf = new StringBuilder();
                    ParameterizedVisitor v1 = ParameterizedOutputVisitorUtils.createParameterizedOutputVisitor(buf, dbType);
                    preStmt.accept(v1);
                    if (out.toString().equals(buf.toString())) continue;
                }
                if (!preStmt.isAfterSemi()) {
                    out.append(";\n");
                } else {
                    out.append('\n');
                }
            }
            if (stmt.hasBeforeComment()) {
                stmt.getBeforeCommentsDirect().clear();
            }
            if ((stmtClass = stmt.getClass()) == SQLSelectStatement.class) {
                SQLSelectStatement selectStatement = (SQLSelectStatement)stmt;
                visitor.visit(selectStatement);
                visitor.postVisit(selectStatement);
                continue;
            }
            stmt.accept(visitor);
        }
        if (visitor.getReplaceCount() == 0 && parser.getLexer().getCommentCount() == 0 && sql.charAt(0) != '/') {
            return sql;
        }
        return out.toString();
    }

    public static long parameterizeHash(String sql, String dbType, List<Object> outParameters) {
        return ParameterizedOutputVisitorUtils.parameterizeHash(sql, dbType, null, outParameters, null);
    }

    public static long parameterizeHash(String sql, String dbType, SQLSelectListCache selectListCache, List<Object> outParameters, VisitorFeature ... visitorFeatures) {
        List<SQLStatement> statementList;
        int stmtSize;
        SQLParserFeature[] features = outParameters == null ? defaultFeatures2 : defaultFeatures;
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser(sql, dbType, features);
        if (selectListCache != null) {
            parser.setSelectListCache(selectListCache);
        }
        if ((stmtSize = (statementList = parser.parseStatementList()).size()) == 0) {
            return 0L;
        }
        StringBuilder out = new StringBuilder(sql.length());
        ParameterizedVisitor visitor = ParameterizedOutputVisitorUtils.createParameterizedOutputVisitor(out, dbType);
        if (outParameters != null) {
            visitor.setOutputParameters(outParameters);
        }
        ParameterizedOutputVisitorUtils.configVisitorFeatures(visitor, visitorFeatures);
        if (stmtSize == 1) {
            SQLStatement stmt = statementList.get(0);
            if (stmt.getClass() == SQLSelectStatement.class) {
                SQLSelectQueryBlock queryBlock;
                SQLSelectStatement selectStmt = (SQLSelectStatement)stmt;
                if (selectListCache != null && (queryBlock = selectStmt.getSelect().getQueryBlock()) != null) {
                    String cachedSelectList = queryBlock.getCachedSelectList();
                    long cachedSelectListHash = queryBlock.getCachedSelectListHash();
                    if (cachedSelectList != null) {
                        visitor.config(VisitorFeature.OutputSkipSelectListCacheString, true);
                    }
                    visitor.visit(selectStmt);
                    return FnvHash.fnv1a_64_lower(cachedSelectListHash, out);
                }
                visitor.visit(selectStmt);
            } else if (stmt.getClass() == MySqlInsertStatement.class) {
                MySqlInsertStatement insertStmt = (MySqlInsertStatement)stmt;
                String columnsString = insertStmt.getColumnsString();
                if (columnsString != null) {
                    long columnsStringHash = insertStmt.getColumnsStringHash();
                    visitor.config(VisitorFeature.OutputSkipInsertColumnsString, true);
                    ((MySqlASTVisitor)((Object)visitor)).visit(insertStmt);
                    return FnvHash.fnv1a_64_lower(columnsStringHash, out);
                }
            } else {
                stmt.accept(visitor);
            }
            return FnvHash.fnv1a_64_lower(out);
        }
        for (int i = 0; i < statementList.size(); ++i) {
            Class<?> stmtClass;
            SQLStatement stmt;
            if (i > 0) {
                out.append(";\n");
            }
            if ((stmt = statementList.get(i)).hasBeforeComment()) {
                stmt.getBeforeCommentsDirect().clear();
            }
            if ((stmtClass = stmt.getClass()) == SQLSelectStatement.class) {
                SQLSelectStatement selectStatement = (SQLSelectStatement)stmt;
                visitor.visit(selectStatement);
                visitor.postVisit(selectStatement);
                continue;
            }
            stmt.accept(visitor);
        }
        return FnvHash.fnv1a_64_lower(out);
    }

    public static String parameterize(List<SQLStatement> statementList, String dbType) {
        StringBuilder out = new StringBuilder();
        ParameterizedVisitor visitor = ParameterizedOutputVisitorUtils.createParameterizedOutputVisitor(out, dbType);
        for (int i = 0; i < statementList.size(); ++i) {
            SQLStatement stmt;
            if (i > 0) {
                out.append(";\n");
            }
            if ((stmt = statementList.get(i)).hasBeforeComment()) {
                stmt.getBeforeCommentsDirect().clear();
            }
            stmt.accept(visitor);
        }
        return out.toString();
    }

    public static ParameterizedVisitor createParameterizedOutputVisitor(Appendable out, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return new OracleParameterizedOutputVisitor(out);
        }
        if ("mysql".equals(dbType) || "mariadb".equals(dbType) || "h2".equals(dbType)) {
            return new MySqlOutputVisitor(out, true);
        }
        if ("postgresql".equals(dbType) || "edb".equals(dbType)) {
            return new PGOutputVisitor(out, true);
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new SQLServerOutputVisitor(out, true);
        }
        if ("db2".equals(dbType)) {
            return new DB2OutputVisitor(out, true);
        }
        if ("phoenix".equals(dbType)) {
            return new PhoenixOutputVisitor(out, true);
        }
        if ("elastic_search".equals(dbType)) {
            return new MySqlOutputVisitor(out, true);
        }
        return new SQLASTOutputVisitor(out, true);
    }

    public static String restore(String sql, String dbType, List<Object> parameters) {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        StringBuilder out = new StringBuilder();
        SQLASTOutputVisitor visitor = SQLUtils.createOutputVisitor(out, dbType);
        visitor.setInputParameters(parameters);
        for (SQLStatement stmt : stmtList) {
            stmt.accept(visitor);
        }
        return out.toString();
    }
}

